AEC aec;
PFont font;

void setup() {
  frameRate(25);
  size(1200, 400);
 
  font = createFont("Arial", 26);
  textFont(font);
  
  aec = new AEC();
  aec.init();
}

void draw() {
  aec.beginDraw();

  // DRAW CODE
  background(0, 0,0);

  // draw some text (with scaled width to make it fit)
  textAlign(LEFT, CENTER);
  pushMatrix();
  scale(0.5, 1.0);
  text("TEXT", 9, 9);
  popMatrix();
  
  noStroke();

  // draw a bar at the mouse position
  int x1 = mouseX / aec.getScaleX();  
  int step = 1;
  for (int y = 0; y < 30; y += step) {
    fill((y % 2 == 0 ? 0 : 254), 0, (y % 2 == 0 ? 254 : 0));
    rect(x1, y, 1, step);
  }
  
  // draw a second moving column
  int x2 = (frameCount / 3) % 55;  
  for (int y = 0; y < 30; y += step) {
    fill((y % 2 != 0 ? 0 : 254), 0, (y % 2 != 0 ? 254 : 0));
    rect(x2, y, 1, step);
  }
  
  aec.endDraw();
  aec.drawSides();
}

void keyPressed() {
  aec.keyPressed(key);
}